function out=crIPmat(data)
% PURPOSE:
% Transform a vector into a square matrix row-wise
% INPUTS:
% data:  A kx1 vector to be transformed to a  N-1xN-1 matrix.  
%        N must ba solution to the equation k^1-k-2*k=0

% OUTPUTS:
% out:  a N-1 by N-1 matrix. the elements above the main antidiagonal are 
%       filled by the elements of the vector data and all other elements are
%       equal to zeros. For example, if data is: data=[2 3 4 5 6 7]' then
%       the rows of out are given below
% out(:,1)=[2 3 4]
% out(:,2)=[5 6 0]
% out(:,3)=[7 0 0]

% Author: Manthos Vogiatzoglou, UoM, 2008

mat=ivecl(data);
[R, C]=size(mat);
out=2.01*ones(C-1);
for i=1:C-1
    out(:,i)=[diag(mat,i); zeros(i-1,1)];
end

